 ; Ŀ
 ;   Repo - reinsert all insertions of a block, or all insertions of all   
 ;   blocks for which dwg files can be found in the search path.           
 ;   Copyright 1994, 1997, 2002, 2006, 2008, 2010 by Rocket Software Ltd.  
 ;   The subroutine Bluntt currently replaces attributes by tag rather     
 ;   than by position, this can be changed in the routine, which is        
 ;   probably not a good idea unless you know exactly what you are doing.  
 ;                                                                         
 ;   Plate of shrimp software.                                             
 ; 

 ; Ŀ
 ;   Blisto - get a list of the names of all blocks in the drawing.        
 ;   Takes no arguments, calls nothing, returns a list.                    
 ;   This includes anonymous blocks, whose names begin with *, but         
 ;   apparently dimension block names begin with *D and can thus be        
 ;   ditched.  Also xrefs are not included.                                
 ; 
 (DEFUN BLISTO (/ rew nexb namm blist)
  (setq rew T)
  (while (setq nexb (tblnext "block" rew))
         (setq rew ())
         (setq namm (cdr (assoc 2 nexb)))
         (setq isx (isxnam namm))
;         (if (= (substr namm 1 2) "*D")
;             (progn
;                  (write-line "\n")
;                  (print nexb)
;                  (print (setq entt (entget (cdr (assoc -2 nexb)))))
;                  (print (setq entt (entget (cdr (assoc 330 entt)))))
;                  (print (setq enam (cdr (assoc 360 entt))))
;                  (print (entget enam))))
         (if (and (/= (substr namm 1 2) "*D")
                  (not isx))
             (setq blist (cons namm blist))))
 blist)
 ; Ŀ
 ;   Blisto end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Bluntt - block replacer.                                   
 ;   Arguments: Blnam, a block name.                                       
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BLUNTT (blnam / how limch atrq *error* ss num esav enam entt pa rota
                                          xsc ysc zsc layy main sub tagg cc)
 ; Ŀ
 ;   Decide how to reapply attribute values - by Attribute or in Order.    
 ; 
   (setq how "Attribute")
 ; (setq how "Order")
 ; Ŀ
 ;   Make sure that a couple of settings are correct for this situation.   
 ; 
  (setq limch (getvar "limcheck"))
  (setvar "limcheck" 0)
  (setq atrq (getvar "attreq"))
  (setvar "attreq" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "attreq" atrq)
   (setvar "limcheck" limch)
  (princ))
 ; Ŀ
 ;   Get an ss of blocks by that name.                                     
 ; 
  (if (setq ss (ssget "X" (list (cons 2 blnam))))
      (progn
 ; Ŀ
 ;   The selection set processor loop.                                     
 ; 
           (setq num 0)
           (while (setq esav (setq enam (ssname ss num)))
                  (setq num (1+ num))
                  (setq entt (entget enam))
 ; Ŀ
 ;   Find the block insertion, X, Y, and Z scales, rotation and layer.     
 ; 
                  (setq pa (cdr (assoc 10 entt)))
                  (setq rota (cdr (assoc 50 entt)))
                  (if rota
                      (setq rota (/ (* 180 rota) pi))
                      (setq rota 0))
                  (if (null (setq xsc (cdr (assoc 41 entt))))
                      (setq xsc 1))
                  (if (null (setq ysc (cdr (assoc 42 entt))))
                      (setq ysc 1))
                  (if (null (setq zsc (cdr (assoc 43 entt))))
                      (setq zsc 1))
                  (setq layy (assoc 8 entt))
 ; Ŀ
 ;   Step through the block and get attribute tags and values.             
 ;   (if there are attributes - the 66 sublist is present.)                
 ; 
                  (setq main ())
                  (if (assoc 66 (entget enam))
                      (while (and (setq enam (entnext enam))
                                 (/= (cdr (assoc 0 (setq entt (entget enam))))
                                                                     "SEQEND"))
                             (setq sub (list (assoc 2 entt) (assoc 1 entt)))
                             (setq main (append main (list sub)))))
 ; Ŀ
 ;   Now erase the old block and insert the new one.                       
 ; 
                  (entdel esav)
                  (command "insert" blnam pa "xyz" xsc ysc zsc rota)
                  (setq esav (setq enam (entlast)))
 ; Ŀ
 ;   And reapply the attribute values depending on the value of How.       
 ; 
                  (cond ((or (= how "Attribute") (= how "Tag"))
                         (while (and (setq enam (entnext enam))
                                     (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                                (setq tagg (assoc 2 entt))
                                (if (setq cc (assoc tagg main))
                                    (entmod (subst (cadr cc)
                                                   (assoc 1 entt) entt))
                                    (if (null usedef)
                                        (entmod (subst (cons 1 "")
                                                      (assoc 1 entt) entt))))))
                        ((= how "Order")
                         (while (and (setq enam (entnext enam))
                                     (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                                (setq cc (cadar main))
                                (setq main (cdr main))
                                (if cc
                                    (entmod (subst cc (assoc 1 entt) entt))
                                    (if (null usedef)
                                        (entmod (subst (cons 1 "")
                                                     (assoc 1 entt) entt)))))))
 ; Ŀ
 ;   Put the block on the correct layer.                                   
 ; 
                  (setq entt (entget esav))
                  (entmod (subst layy (assoc 8 entt) entt)))))
 ; Ŀ
 ;   Report.                                                               
 ; 
  (if num (write-line (strcat "\n" (itoa num) " block"
                              (if (= num 1) "" "s") " replaced.")))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (setvar "attreq" atrq)
  (setvar "limcheck" limch)
 (princ))
 ; Ŀ
 ;   Bluntt end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Fffa - find files using paths from a list.                 
 ;   Argument: Ff, a file name.                                            
 ;   Calls nothing.                                                        
 ;   Returns a list of file names or nil.                                  
 ; 
 (DEFUN FFFA (ff / typ ll prefa fn flist)
  (setq typ (list "T:\\CADD\\Drafting Electrical\\Details\\"))
  (setq ll 0)
  (while (setq prefa (nth ll typ))
         (setq ll (1+ ll))
         (if (setq fn (findfile (strcat prefa ff)))
             (setq flist (cons fn flist))))
 (reverse flist))
 ; Ŀ
 ;   Subroutine Fffa end.                                                  
 ; 

 ; Ŀ
 ;   Gpth - try to find a drawing, first in the directory containing       
 ;   the current drawing, then in the entire search path, then using       
 ;   fffa which has its own internal path list.                            
 ;   Takes one argument: Fnam, a drawing filename.                         
 ;   Returns a filename with path.                                         
 ; 
 (DEFUN GPTH (fnam / len nampth flist)
  (if (or (< (setq len (strlen fnam)) 5)
          (/= (strcase (substr fnam (- len 3))) ".DWG"))
      (setq fnam (strcat fnam ".dwg")))
  (cond ((setq nampth (findfile (strcat (getvar "dwgprefix") fnam))))
        ((setq nampth (findfile fnam)))
        ((setq flist (fffa fnam))
         (if (> (length flist) 1)
             (prompt (strcat ">1 copy of " fnam " found.")))
         (setq nampth (car flist))))
 nampth)
 ; Ŀ
 ;   Gpth end.                                                             
 ; 

 ; Ŀ
 ;   Isxref: see if a given block is an xref.                              
 ;   Arguments: Blnam, either an entity name or a block name string.       
 ;   Returns T if the block was an xref, else nil.                         
 ; 
 (DEFUN ISXREF (blnam / dat xp isxrf)
  (if (= (type blnam) 'ename)
      (setq blnam (cdr (assoc 2 (entget blnam)))))
  (setq dat (tblsearch "block" blnam))
  (setq xp (cdr (assoc 70 dat)))
  (setq isxrf (logand xp 4))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxref end.                                                           
 ; 

 ; Ŀ
 ;   Phath - correct the case of a text string, typically a path.          
 ;   If a path, each directory name is capitalized, if a string the first  
 ;   character is capitalized.  All other characters are in lower case.    
 ;   Takes one argument, a string, which it returns, corrected.            
 ; 
 (DEFUN PHATH (str / strlst sub newstr)
  (setq strlst (splat "\\" str))
  (while (setq sub (car strlst))
         (setq strlst (cdr strlst))
         (setq sub (strcat (strcase (substr sub 1 1))
                                    (strcase (substr sub 2) t)))
         (if (null newstr)
             (setq newstr sub)
             (setq newstr (strcat newstr "\\" sub))))
 newstr)
 ; Ŀ
 ;   Phath end.                                                            
 ; 

 ; Ŀ
 ;   Reppa - reinsert all blocks named in a list if they are present in    
 ;   the current drawing and if they can be found as Dwg files.            
 ;   Arguments: Blista, a list of block names.                             
 ;              Upa, T = update blocks which are defined but not           
 ;                   inserted, nil = don't.                                
 ;   Calls Gpth to look for the file (first locally, then anywhere),       
 ;   and Phath to correct the block name for error messages.               
 ;   Returns nothing.                                                      
 ; 
 (DEFUN REPPA (blista upa / num nexb filnam)
  (setq num 0)
 ; Ŀ
 ;   While there are blocks in the list, see if they can be updated.       
 ; 
  (while (setq nexb (nth num blista))
         (setq num (1+ num))
 ; Ŀ
 ;   The block isn't present in the block tables.                          
 ; 
         (cond ((null (tblsearch "block" nexb))
                (write-line (strcat "\nBlock " (phath nexb)
                                    " not defined in drawing; not updated.")))
 ; Ŀ
 ;   The block is an xref.                                                 
 ; 
               ((isxref nexb)
                (write-line (strcat "\nXref " (phath nexb)
                                    " not updated.")))
 ; Ŀ
 ;   The block defined but there are no insertions of it.                  
 ;   Update it only if the flag upa is set, which should be the default.   
 ; 
               ((and (null upa)
                     (null (ssget "X" (list (cons 2 nexb)))))
                (write-line (strcat "\nBlock " (phath nexb)
                                    " not present in drawing; not updated.")))
 ; Ŀ
 ;   There is no file available which matches the block name.              
 ; 
               ((null (setq filnam (gpth nexb)))
                (write-line (strcat "\nCan't update " (phath nexb)
                                    " - drawing file not found.")))
 ; Ŀ
 ;   Otherwise insert and thus redefine the block.                         
 ; 
               (t
                (command "insert" (strcat nexb "=" filnam))
                (command "Y")
                (command)
                (write-line (strcat "\nBlock " (phath nexb)
                                    " updated from file: " (phath filnam) "."))
 ; Ŀ
 ;   Replace all inserts.                                                  
 ; 
                (bluntt nexb))))
 (princ))
 ; Ŀ
 ;   Subroutine Reppa end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ;                                                                         
 ;   Completely rewritten 11.19.2000.                                      
 ; 
 (DEFUN SPLAT (sepchr linn / pos len name1 strlst)
  (while (/= (strlen linn) 0)
 ; Ŀ
 ;   Find the first separator character, save everything before it into    
 ;   the Name1 variable, remove it from the start of the string Linn.      
 ; 
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
 ; Ŀ
 ;   Remove spaces from the front and back of Name1.                       
 ; 
         (while (and (> (strlen name1) 0)
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (while (and (> (strlen name1) 0)
                     (= (substr name1 1 1) " "))
                (setq name1 (substr name1 2)))
 ; Ŀ
 ;   Add Name1 to the substring list Strlst.                               
 ; 
         (setq strlst (append strlst (list name1))))
 ; Ŀ
 ;   If the string contained no separator characters then Strlst will be   
 ;   nil, so return a list containing the original string.                 
 ; 
  (if (null strlst) (setq strlst (list linn)))
 strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Repo.                                                                 
 ; 
 (DEFUN C:REPO (/ snapp osmo reg *error* enampt blist blnam)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
 ; Ŀ
 ;   Turn off snap, rehash settings, etc.                                  
 ; 
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Turn off regen so that the drawing doesn't keep regenerating.         
 ; 
  (setq reg (getvar "regenmode"))
  (command "regenauto" "off")
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (if shk (print shk))
   (setvar "osmode" osmo)
   (setvar "snapmode" snapp)
 ; Ŀ
 ;   If Regenauto was off then turn it on, which will on will force a      
 ;   regen, if not then regen.                                             
 ; 
   (if (= reg 1)
       (command "regenauto" "on")
       (command "regen"))
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   If there is a script running or the user doesn't pick a block, get a  
 ;   list of all blocks in the drawing.                                    
 ;   Otherwise get a single block name.                                    
 ; 
  (cond ((or (= 4 (logand 4 (getvar "cmdactive")))       ; during a script
             (null (setq enampt (entsel
                               "Pick Block to Update or Return for <All>: "))))
         (setq blist (blisto)))
        (t
         (if (setq blnam (cdr (assoc 2 (entget (car enampt)))))
             (setq blist (list blnam))
             (prompt "\nThat was not a block."))))
 ; Ŀ
 ;   Call Reppa to update the block names in the list.                     
 ; 
  (if blist (reppa blist t))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* ())
 ; Ŀ
 ;   Resume, because if there is a batch running then (command) will have  
 ;   stopped it.                                                           
 ; 
  (command "resume")
 (princ))